/*=============================================================================}
{ Main properties were set at design time:                                     }
{ Table1->TableName           = "SampleTable.db"; // Paradox table             }
{ Table1->ReadOnly            = false;                                         }
{ DataSource1->Dataset        = Table1;                                        }
{ DBNavigator1->DataSource    = DataSource1;                                   }
{ DBEdit1->DataSource         = DataSource1;                                   }
{ DBRichViewEdit1->DataSource = DataSource1;                                   }
{ DBRichViewEdit1->Style      = RVStyle1;                                      }
{ DBEdit1->DataField          = "Caption";  // Alphanumeric field              }
{ DBRichViewEdit1->DataField  = "RVFField"; // Binary field                    }
{ nbEdit was removed from DBNavigator1->VisibleButtons (because of autoedit)   }
{------------------------------------------------------------------------------}
{ DBRichViewEdit has data-aware features that require no code to use           }
{ (just like most of other Delphi db controls).                                }
{ Some more event handlers are needed for advanced RVF features, such as saving}
{ "bullets" and "hotspots". There is no difference here with saving/loading    }
{ RVF files.                                                                   }
{ The code below opens table, updates label displaying record number,          }
{ provides "bold" button functionality.                                        }
{------------------------------------------------------------------------------}
{ Note: changes after last posting are not saved when exiting application.     }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "DBRV"
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Opening table...
  Table1->DatabaseName = ExtractFilePath(Application->ExeName);
  Table1->Open();
  // For demonstrating rich text ability of TDBRichViewEdit,
  // we've added "Bold" button. It will switch the 0-th and the 1-st styles.
  // Making 1-st text style a bold copy of 0-th style...
  RVStyle1->TextStyles->Items[1] = RVStyle1->TextStyles->Items[0];
  RVStyle1->TextStyles->Items[1]->Style << fsBold;
}
//---------------------------------------------------------------------------
void TForm1::UpdateStatusLabel()
{
  if (Table1->RecordCount==0)
    Label3->Caption = "(empty)";
  else if (Table1->RecNo<1)
    Label3->Caption = "(new)";
  else
    Label3->Caption = Format("Record %d of %d", ARRAYOFCONST(((int)Table1->RecNo, (int)Table1->RecordCount)));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DataSource1DataChange(TObject *Sender, TField *Field)
{
  UpdateStatusLabel();    
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DBRichViewEdit1CurTextStyleChanged(TObject *Sender)
{
  SpeedButton1->Down = DBRichViewEdit1->CurTextStyleNo!=0;    
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
  // switching 1-st and 0-th styles
  if (SpeedButton1->Down)
    DBRichViewEdit1->ApplyTextStyle(1);
  else
    DBRichViewEdit1->ApplyTextStyle(0);
}
//---------------------------------------------------------------------------
